/*
 * Decompiled with CFR 0.152.
 */
package com.esri.geoevent.adapter.trimble.taip;

import com.esri.geoevent.adapter.trimble.taip.TAIP0xF0MessageTranslator;
import com.esri.geoevent.adapter.trimble.taip.TAIP0xF1MessageTranslator;
import com.esri.geoevent.adapter.trimble.taip.TAIP0xF2MessageTranslator;
import com.esri.geoevent.adapter.trimble.taip.TAIPMessageTranslator;
import com.esri.geoevent.adapter.trimble.taip.TAIPRAMMessageTranslator;
import com.esri.ges.adapter.AdapterDefinition;
import com.esri.ges.adapter.InboundAdapterBase;
import com.esri.ges.core.component.ComponentException;
import com.esri.ges.core.geoevent.GeoEvent;
import com.esri.ges.core.geoevent.GeoEventDefinition;
import com.esri.ges.framework.i18n.BundleLogger;
import com.esri.ges.framework.i18n.BundleLoggerFactory;
import com.esri.ges.manager.geoeventdefinition.GeoEventDefinitionManagerException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TaipInboundAdapter
extends InboundAdapterBase {
    private static final BundleLogger LOGGER = BundleLoggerFactory.getLogger(TaipInboundAdapter.class);
    private final Map<String, TAIPMessageTranslator> translators = new HashMap<String, TAIPMessageTranslator>();
    private final Map<String, String> lookup = new HashMap<String, String>();
    private final Map<String, GeoEventDefinition> eventDefinitionMap = new HashMap<String, GeoEventDefinition>();

    public TaipInboundAdapter(AdapterDefinition definition) throws ComponentException {
        super(definition);
        this.lookup.put("RPV", "TAIP0xF0");
        this.lookup.put("RCP", "TAIP0xF1");
        this.lookup.put("RLN", "TAIP0xF2");
        this.lookup.put("RAM", "TAIPRAM");
        this.translators.put("RPV", new TAIP0xF0MessageTranslator());
        this.translators.put("RCP", new TAIP0xF1MessageTranslator());
        this.translators.put("RLN", new TAIP0xF2MessageTranslator());
        this.translators.put("RAM", new TAIPRAMMessageTranslator());
    }

    public GeoEvent adapt(ByteBuffer buffer, String channelId) {
        return null;
    }

    public void receive(ByteBuffer buffer, String channelId) {
        new Thread(new GeoEventProducer(channelId, TaipInboundAdapter.index(buffer))).start();
    }

    public void shutdown() {
        super.shutdown();
        this.translators.clear();
        this.lookup.clear();
    }

    private static List<byte[]> index(ByteBuffer in) {
        ArrayList<byte[]> messages = new ArrayList<byte[]>();
        int i = -1;
        while (in.hasRemaining()) {
            byte b = in.get();
            if (b == 62) {
                i = in.position();
                in.mark();
                continue;
            }
            if (b == 60) {
                if (i != -1) {
                    byte[] message = new byte[in.position() - 1 - i];
                    System.arraycopy(in.array(), i, message, 0, message.length);
                    messages.add(message);
                }
                i = -1;
                in.mark();
                continue;
            }
            if (!messages.isEmpty() || i != -1) continue;
            in.mark();
        }
        return messages;
    }

    private GeoEventDefinition lookupGeoEventDef(GeoEventDefinition eventDefinition) {
        String guid;
        GeoEventDefinition def = null;
        if (eventDefinition != null && (def = this.eventDefinitionMap.get(guid = eventDefinition.getGuid())) == null) {
            def = this.geoEventCreator.getGeoEventDefinitionManager().getGeoEventDefinition(guid);
            if (def == null) {
                String name = eventDefinition.getName();
                String owner = eventDefinition.getOwner();
                def = this.geoEventCreator.getGeoEventDefinitionManager().searchGeoEventDefinition(name, owner);
                if (def == null) {
                    Collection searchResults = this.geoEventCreator.getGeoEventDefinitionManager().searchGeoEventDefinitionByName(name);
                    if (searchResults != null && searchResults.size() > 0) {
                        int inDefFieldListSize = eventDefinition.getFieldDefinitions().size();
                        for (GeoEventDefinition systemDef : searchResults) {
                            if (systemDef.getFieldDefinitions().size() != inDefFieldListSize) continue;
                            def = systemDef;
                            break;
                        }
                    }
                    if (def == null) {
                        try {
                            def = this.geoEventCreator.getGeoEventDefinitionManager().addGeoEventDefinition(eventDefinition);
                        }
                        catch (GeoEventDefinitionManagerException e) {
                            LOGGER.error("Failed to find {0} GeoEvent Definition and can't create it.", (Throwable)e, new Object[]{name});
                        }
                    }
                }
            }
            if (def != null) {
                this.eventDefinitionMap.put(guid, def);
            } else {
                LOGGER.error("Failed to find GeoEvent Definition with GUID {0} named {1}. Can't continue.", new Object[]{guid, eventDefinition.getName()});
            }
        }
        return def;
    }

    private class GeoEventProducer
    implements Runnable {
        private String channelId;
        private List<byte[]> messages;

        public GeoEventProducer(String channelId, List<byte[]> messages) {
            this.channelId = channelId;
            this.messages = messages;
        }

        @Override
        public void run() {
            while (!this.messages.isEmpty()) {
                ByteBuffer message = ByteBuffer.wrap(this.messages.remove(0));
                if (message.remaining() < 3) continue;
                byte[] chars = new byte[3];
                message.get(chars);
                String taipFormat = new String(chars);
                if (TaipInboundAdapter.this.lookup.containsKey(taipFormat)) {
                    try {
                        GeoEventDefinition geoEventDef = TaipInboundAdapter.this.lookupGeoEventDef(((AdapterDefinition)TaipInboundAdapter.this.definition).getGeoEventDefinition((String)TaipInboundAdapter.this.lookup.get(taipFormat)));
                        GeoEvent geoEvent = TaipInboundAdapter.this.geoEventCreator.create(geoEventDef.getGuid());
                        ((TAIPMessageTranslator)TaipInboundAdapter.this.translators.get(taipFormat)).translate(this.channelId, message, geoEvent);
                        TaipInboundAdapter.this.geoEventListener.receive(geoEvent);
                    }
                    catch (Throwable error) {
                        LOGGER.warn("TRANSLATION_ERROR", new Object[]{error.getMessage()});
                        LOGGER.debug(error.getMessage(), error);
                    }
                    continue;
                }
                LOGGER.debug("TRANSLATION_ERROR_FORMAT_NOT_SUPPORTED", new Object[]{taipFormat});
            }
        }
    }
}

