/*
 * Decompiled with CFR 0.152.
 */
package com.esri.geoevent.adapter.trimble.taip;

import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.MapGeometry;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.SpatialReference;
import com.esri.geoevent.adapter.trimble.taip.TAIPMessageTranslator;
import com.esri.ges.core.geoevent.FieldException;
import com.esri.ges.core.geoevent.GeoEvent;
import com.esri.ges.messaging.MessagingException;
import com.esri.ges.util.GeometryUtil;
import java.nio.ByteBuffer;

public class TAIPRAMMessageTranslator
extends TAIPMessageTranslator {
    @Override
    protected void translate(String trackId, ByteBuffer buf, GeoEvent geoEvent) throws MessagingException, FieldException {
        int i = 0;
        geoEvent.setField(i++, (Object)trackId);
        Integer time = this.convertToInteger(this.readString(buf, 5));
        geoEvent.setField(i++, time != null ? this.toTime(time, 0) : null);
        Long y = this.convertToLong(this.readString(buf, 8).replace('+', ' ').trim());
        Long x = this.convertToLong(this.readString(buf, 9).replace('+', ' ').trim());
        if (x != null && y != null) {
            MapGeometry geometry = new MapGeometry((Geometry)new Point((double)x.longValue() * 1.0E-5, (double)y.longValue() * 1.0E-5), SpatialReference.create((int)4326));
            geoEvent.setField(i++, (Object)GeometryUtil.toJson((MapGeometry)geometry));
        }
        geoEvent.setField(i++, (Object)Short.parseShort(this.readString(buf, 3).trim()));
        geoEvent.setField(i++, (Object)Short.parseShort(this.readString(buf, 3).trim()));
        geoEvent.setField(i++, (Object)this.readString(buf, 1).trim());
        geoEvent.setField(i++, (Object)Short.parseShort(this.readString(buf, 1).trim()));
        geoEvent.setField(i++, (Object)Short.parseShort(this.readString(buf, 1)));
        short optionalStringLength = Short.parseShort(this.readString(buf, 2));
        geoEvent.setField(i++, (Object)optionalStringLength);
        geoEvent.setField(i++, (Object)this.readString(buf, optionalStringLength));
        this.readIDField(buf, geoEvent, i);
    }
}

