/*
 * Decompiled with CFR 0.152.
 */
package com.esri.geoevent.adapter.trimble.taip;

import com.esri.geoevent.adapter.trimble.taip.TaipInboundAdapter;
import com.esri.ges.core.geoevent.FieldException;
import com.esri.ges.core.geoevent.GeoEvent;
import com.esri.ges.framework.i18n.BundleLogger;
import com.esri.ges.framework.i18n.BundleLoggerFactory;
import com.esri.ges.messaging.GeoEventCreator;
import com.esri.ges.messaging.MessagingException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public abstract class TAIPMessageTranslator {
    private static final BundleLogger LOGGER = BundleLoggerFactory.getLogger(TaipInboundAdapter.class);
    protected GeoEventCreator geoEventCreator;

    protected abstract void translate(String var1, ByteBuffer var2, GeoEvent var3) throws MessagingException, FieldException;

    protected String readString(ByteBuffer from, int bytes) throws MessagingException {
        if (from.remaining() >= bytes) {
            byte[] buf = new byte[bytes];
            from.get(buf);
            return new String(buf);
        }
        throw new MessagingException(LOGGER.translate("MESSAGE_SIZE_VALIDATION", new Object[]{bytes, from.remaining()}));
    }

    protected Date toTime(Integer s, Integer ms) {
        if (s != null) {
            Calendar c = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            int zh = s / 3600;
            int zm = s / 60 - zh * 60;
            int zs = s - (zh * 3600 + zm * 60);
            c.set(11, zh);
            c.set(12, zm);
            c.set(13, zs);
            c.set(14, ms);
            return c.getTime();
        }
        return null;
    }

    public boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public Double convertToDouble(String s, Double defaultValue) {
        if (!this.isEmpty(s)) {
            try {
                return Double.parseDouble(s.replaceAll(",", "."));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public Double convertToDouble(Object value) {
        return value != null ? (value instanceof Double ? (Double)value : this.convertToDouble(value.toString(), null)) : null;
    }

    public Integer convertToInteger(Object value) {
        if (value != null) {
            if (value instanceof Integer) {
                return (Integer)value;
            }
            Double doubleValue = this.convertToDouble(value);
            if (doubleValue != null) {
                return Long.valueOf(Math.round(doubleValue)).intValue();
            }
        }
        return null;
    }

    public Short convertToShort(Object value) {
        if (value != null) {
            if (value instanceof Short) {
                return (Short)value;
            }
            Double doubleValue = this.convertToDouble(value);
            if (doubleValue != null) {
                return Long.valueOf(Math.round(doubleValue)).shortValue();
            }
        }
        return null;
    }

    public Long convertToLong(Object value) {
        if (value != null) {
            if (value instanceof Long) {
                return (Long)value;
            }
            Double doubleValue = this.convertToDouble(value);
            if (doubleValue != null) {
                return Math.round(doubleValue);
            }
        }
        return null;
    }

    public void readIDField(ByteBuffer buf, GeoEvent geoEvent, int i) throws MessagingException, FieldException {
        String remainderString = "";
        try {
            String id;
            StringBuilder remainder = new StringBuilder();
            String next = "";
            while (!"<".equals(next) && !">".equals(next) && buf.hasRemaining()) {
                buf.mark();
                next = this.readString(buf, 1);
                if (">".equals(next)) {
                    buf.reset();
                    break;
                }
                remainder.append(next);
            }
            String[] remValueArray = new String[]{null, null};
            remainderString = remainder.toString();
            if (remainderString != null && !remainderString.isEmpty()) {
                remainderString = remainderString.replace("<", "").replace(">", "");
                LOGGER.trace("Parsing remaining message string {0}", new Object[]{remainderString});
                String[] finalFields = remainderString.split(";");
                Arrays.stream(finalFields).forEach(remString -> {
                    if (remString != null && !remString.trim().isEmpty()) {
                        LOGGER.trace("Parsing remaining message string fragment {0}", new Object[]{remString});
                        if (remString.toUpperCase().startsWith("ID=")) {
                            remValueArray[0] = remString.substring(3);
                        } else if (remString.startsWith("*")) {
                            remValueArray[1] = remString.substring(1);
                        }
                    }
                });
            }
            if (remValueArray[0] != null && !(id = remValueArray[0].trim()).isEmpty()) {
                LOGGER.trace("Setting event ID: {0}", new Object[]{id});
                geoEvent.setField(i++, (Object)id);
            }
        }
        catch (Exception e) {
            LOGGER.debug("Failed to parse ID field (remainder: {0}), moving on...", (Throwable)e, new Object[]{remainderString});
        }
    }
}

