/*
 * Decompiled with CFR 0.152.
 */
package com.esri.geoevent.adapter.trimble.taip;

import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.MapGeometry;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.SpatialReference;
import com.esri.geoevent.adapter.trimble.taip.TAIPMessageTranslator;
import com.esri.ges.core.geoevent.FieldException;
import com.esri.ges.core.geoevent.GeoEvent;
import com.esri.ges.messaging.MessagingException;
import com.esri.ges.util.GeometryUtil;
import java.nio.ByteBuffer;

public class TAIP0xF2MessageTranslator
extends TAIPMessageTranslator {
    @Override
    protected void translate(String trackId, ByteBuffer buf, GeoEvent geoEvent) throws MessagingException, FieldException {
        int i = 0;
        geoEvent.setField(i++, (Object)trackId);
        Integer time = this.convertToInteger(this.readString(buf, 8));
        geoEvent.setField(i++, time != null ? this.toTime(time / 1000, time % 1000) : null);
        Long y = this.convertToLong(this.readString(buf, 10).replace('+', ' ').trim());
        Long x = this.convertToLong(this.readString(buf, 11).replace('+', ' ').trim());
        if (x != null && y != null) {
            MapGeometry geometry = new MapGeometry((Geometry)new Point((double)x.longValue() * 1.0E-7, (double)y.longValue() * 1.0E-7), SpatialReference.create((int)4326));
            geoEvent.setField(i++, (Object)GeometryUtil.toJson((MapGeometry)geometry));
        }
        geoEvent.setField(i++, (Object)((double)this.convertToLong(this.readString(buf, 9).replace('+', ' ').trim()).longValue() * 0.01));
        geoEvent.setField(i++, (Object)((double)this.convertToLong(this.readString(buf, 4).replace('+', ' ').trim()).longValue() * 0.1));
        geoEvent.setField(i++, (Object)((double)this.convertToLong(this.readString(buf, 5).replace('+', ' ').trim()).longValue() * 0.1));
        geoEvent.setField(i++, (Object)((double)this.convertToLong(this.readString(buf, 4).replace('+', ' ').trim()).longValue() * 0.1));
        int num_svs = this.convertToShort(this.readString(buf, 2)).shortValue();
        geoEvent.setField(i++, (Object)((short)num_svs));
        String[] str_sv_id = new String[num_svs];
        String[] str_iode = new String[num_svs];
        for (int j = 0; j < num_svs; ++j) {
            str_sv_id[j] = this.readString(buf, 2);
            str_iode[j] = this.readString(buf, 2);
        }
        String sv = "";
        for (int k = 0; k < str_sv_id.length; ++k) {
            sv = sv + str_sv_id[k] + ":" + str_iode[k];
            if (k >= num_svs - 1) continue;
            sv = sv + ",";
        }
        geoEvent.setField(i++, (Object)sv);
        geoEvent.setField(i++, (Object)this.readString(buf, 10));
        geoEvent.setField(i++, (Object)this.convertToShort(this.readString(buf, 1)));
        geoEvent.setField(i++, (Object)this.convertToShort(this.readString(buf, 1)));
        this.readIDField(buf, geoEvent, i);
    }
}

