/*
 * Decompiled with CFR 0.152.
 */
package com.esri.geoevent.processor.spatialfieldenricher;

import com.esri.ges.framework.i18n.BundleLogger;
import com.esri.ges.framework.i18n.BundleLoggerFactory;
import com.esri.ges.util.Validator;

public enum SpatialUnits {
    esriSRUnit_Meter,
    esriSRUnit_StatuteMile,
    esriSRUnit_Foot,
    esriSRUnit_Kilometer,
    esriSRUnit_NauticalMile,
    esriSRUnit_USNauticalMile;

    private static final BundleLogger LOGGER;

    static {
        LOGGER = BundleLoggerFactory.getLogger(SpatialUnits.class);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toLabel() {
        return this.toString(true);
    }

    private String toString(boolean asLabel) {
        switch (this) {
            case esriSRUnit_Meter: {
                return asLabel ? "Meters" : "esriSRUnit_Meter";
            }
            case esriSRUnit_StatuteMile: {
                return asLabel ? "Statue Miles" : "esriSRUnit_StatuteMile";
            }
            case esriSRUnit_Foot: {
                return asLabel ? "Feet" : "esriSRUnit_Foot";
            }
            case esriSRUnit_Kilometer: {
                return asLabel ? "Kilometers" : "esriSRUnit_Kilometer";
            }
            case esriSRUnit_NauticalMile: {
                return asLabel ? "Nautical Miles" : "esriSRUnit_NauticalMile";
            }
            case esriSRUnit_USNauticalMile: {
                return asLabel ? "US Nautical Miles" : "esriSRUnit_USNauticalMile";
            }
        }
        return "";
    }

    public static SpatialUnits fromString(String s) throws IllegalArgumentException {
        String name = Validator.compactWhiteSpaces((String)s);
        if (!name.isEmpty()) {
            if ("Meters".equals(name) || "esriSRUnit_Meter".equals(name)) {
                return esriSRUnit_Meter;
            }
            if ("Statue Miles".equals(name) || "esriSRUnit_StatuteMile".equals(name)) {
                return esriSRUnit_StatuteMile;
            }
            if ("Feet".equals(name) || "esriSRUnit_Foot".equals(name)) {
                return esriSRUnit_Foot;
            }
            if ("Kilometers".equals(name) || "esriSRUnit_Kilometer".equals(name)) {
                return esriSRUnit_Kilometer;
            }
            if ("Nautical Miles".equals(name) || "esriSRUnit_NauticalMile".equals(name)) {
                return esriSRUnit_NauticalMile;
            }
            if ("US Nautical Miles".equals(name) || "esriSRUnit_USNauticalMile".equals(name)) {
                return esriSRUnit_USNauticalMile;
            }
        }
        throw new IllegalArgumentException(LOGGER.translate("INVALID_RESULT_SPATIAL_UNIT_ENUM", new Object[]{name}));
    }
}

