/*
 * Decompiled with CFR 0.152.
 */
package com.esri.geoevent.processor.spatialfieldenricher;

import com.esri.ges.framework.i18n.BundleLogger;
import com.esri.ges.framework.i18n.BundleLoggerFactory;
import com.esri.ges.util.Validator;

public enum SpatialRelations {
    Intersects,
    Contains,
    Crosses,
    EnvelopeIntersects,
    IndexIntersects,
    Overlaps,
    Touches,
    Within;

    private static final BundleLogger LOGGER;

    static {
        LOGGER = BundleLoggerFactory.getLogger(SpatialRelations.class);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toLabel() {
        return this.toString(true);
    }

    private String toString(boolean asLabel) {
        switch (this) {
            case Intersects: {
                return asLabel ? "Intersects" : "esriSpatialRelIntersects";
            }
            case Contains: {
                return asLabel ? "Contains" : "esriSpatialRelContains";
            }
            case Crosses: {
                return asLabel ? "Crosses" : "esriSpatialRelCrosses";
            }
            case EnvelopeIntersects: {
                return asLabel ? "Envelope Intersects" : "esriSpatialRelEnvelopeIntersects";
            }
            case IndexIntersects: {
                return asLabel ? "Index Intersects" : "esriSpatialRelIndexIntersects";
            }
            case Overlaps: {
                return asLabel ? "Overlaps" : "esriSpatialRelOverlaps";
            }
            case Touches: {
                return asLabel ? "Touches" : "esriSpatialRelTouches";
            }
            case Within: {
                return asLabel ? "Within" : "esriSpatialRelWithin";
            }
        }
        return "";
    }

    public static SpatialRelations fromString(String s) throws IllegalArgumentException {
        String name = Validator.compactWhiteSpaces((String)s);
        if (!name.isEmpty()) {
            if ("Intersects".equals(name) || "esriSpatialRelIntersects".equals(name)) {
                return Intersects;
            }
            if ("Contains".equals(name) || "esriSpatialRelContains".equals(name)) {
                return Contains;
            }
            if ("Crosses".equals(name) || "esriSpatialRelCrosses".equals(name)) {
                return Crosses;
            }
            if ("Envelope Intersects".equals(name) || "esriSpatialRelEnvelopeIntersects".equals(name)) {
                return EnvelopeIntersects;
            }
            if ("Index Intersects".equals(name) || "esriSpatialRelIndexIntersects".equals(name)) {
                return IndexIntersects;
            }
            if ("Overlaps".equals(name) || "esriSpatialRelOverlaps".equals(name)) {
                return Overlaps;
            }
            if ("Touches".equals(name) || "esriSpatialRelTouches".equals(name)) {
                return Touches;
            }
            if ("Within".equals(name) || "esriSpatialRelWithin".equals(name)) {
                return Within;
            }
        }
        throw new IllegalArgumentException(LOGGER.translate("INVALID_RESULT_SPATIAL_REL_ENUM", new Object[]{name}));
    }
}

