/*
 * Decompiled with CFR 0.152.
 */
package com.esri.geoevent.processor.spatialfieldenricher;

import com.esri.geoevent.processor.spatialfieldenricher.FeatureServiceQueryDataProvider;
import com.esri.geoevent.processor.spatialfieldenricher.SpatialFieldEnricherProcessor;
import com.esri.geoevent.processor.spatialfieldenricher.SpatialFieldEnricherProcessorDefinition;
import com.esri.ges.core.component.ComponentException;
import com.esri.ges.core.http.GeoEventHttpClientService;
import com.esri.ges.framework.i18n.BundleLogger;
import com.esri.ges.framework.i18n.BundleLoggerFactory;
import com.esri.ges.manager.datastore.agsconnection.ArcGISServerConnectionManager;
import com.esri.ges.manager.tag.TagManager;
import com.esri.ges.messaging.GeoEventCreator;
import com.esri.ges.messaging.Messaging;
import com.esri.ges.processor.GeoEventProcessor;
import com.esri.ges.processor.GeoEventProcessorServiceBase;

public class SpatialFieldEnricherProcessorService
extends GeoEventProcessorServiceBase {
    private static final BundleLogger LOGGER = BundleLoggerFactory.getLogger(SpatialFieldEnricherProcessorService.class);
    private Messaging messaging;
    private GeoEventHttpClientService httpClientService;
    protected GeoEventCreator geoEventCreator;
    protected TagManager tagManager;
    private ArcGISServerConnectionManager arcGISServerConnectionManager;

    public SpatialFieldEnricherProcessorService() {
        this.definition = new SpatialFieldEnricherProcessorDefinition();
        LOGGER.trace("Loaded definition & Started Service");
    }

    public void setHttpClientService(GeoEventHttpClientService httpClientService) {
        this.httpClientService = httpClientService;
    }

    public void setMessaging(Messaging messaging) {
        LOGGER.trace("Set Messaging");
        this.messaging = messaging;
        this.geoEventCreator = messaging.createGeoEventCreator();
    }

    public void setTagManager(TagManager tagManager) {
        LOGGER.trace("Set Tag Manager");
        this.tagManager = tagManager;
    }

    public void setArcGISServerConnectionManager(ArcGISServerConnectionManager arcGISServerConnectionManager) {
        LOGGER.trace("set arcGISServerConnectionManager");
        this.arcGISServerConnectionManager = arcGISServerConnectionManager;
    }

    public GeoEventProcessor create() throws ComponentException {
        LOGGER.trace("Create Spatial Query Field Enricher Service ", new Object[]{this.definition, this.arcGISServerConnectionManager, this.geoEventCreator, this.tagManager});
        SpatialFieldEnricherProcessor fieldEnricher = new SpatialFieldEnricherProcessor(this.definition);
        fieldEnricher.setDataProvider(new FeatureServiceQueryDataProvider(this.arcGISServerConnectionManager, this.httpClientService));
        fieldEnricher.setGeoEventCreator(this.geoEventCreator);
        fieldEnricher.setTagManager(this.tagManager);
        fieldEnricher.setMessaging(this.messaging);
        LOGGER.trace("Created processor");
        return fieldEnricher;
    }
}

