/*
 * Decompiled with CFR 0.152.
 */
package com.esri.geoevent.processor.spatialfieldenricher;

import com.esri.geoevent.processor.spatialfieldenricher.FeatureServiceQueryDataProvider;
import com.esri.geoevent.processor.spatialfieldenricher.ResultDestination;
import com.esri.geoevent.processor.spatialfieldenricher.SpatialRelations;
import com.esri.geoevent.processor.spatialfieldenricher.SpatialUnits;
import com.esri.ges.core.ConfigurationException;
import com.esri.ges.core.component.ComponentException;
import com.esri.ges.core.geoevent.FieldDefinition;
import com.esri.ges.core.geoevent.FieldException;
import com.esri.ges.core.geoevent.GeoEvent;
import com.esri.ges.core.geoevent.GeoEventDefinition;
import com.esri.ges.core.geoevent.GeoEventPropertyName;
import com.esri.ges.core.geoevent.Tag;
import com.esri.ges.core.property.Property;
import com.esri.ges.core.property.PropertyException;
import com.esri.ges.core.validation.ValidationException;
import com.esri.ges.framework.i18n.BundleLogger;
import com.esri.ges.framework.i18n.BundleLoggerFactory;
import com.esri.ges.manager.datastore.agsconnection.ArcGISServerType;
import com.esri.ges.manager.geoeventdefinition.GeoEventDefinitionManager;
import com.esri.ges.manager.geoeventdefinition.GeoEventDefinitionManagerException;
import com.esri.ges.manager.tag.TagManager;
import com.esri.ges.messaging.EventDestination;
import com.esri.ges.messaging.GeoEventCreator;
import com.esri.ges.messaging.GeoEventProducer;
import com.esri.ges.messaging.Messaging;
import com.esri.ges.messaging.MessagingException;
import com.esri.ges.processor.CacheEnabledGeoEventProcessor;
import com.esri.ges.processor.GeoEventProcessorDefinition;
import com.esri.ges.util.Converter;
import com.esri.ges.util.Validator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.ServiceReference;

public class SpatialFieldEnricherProcessor
extends CacheEnabledGeoEventProcessor
implements GeoEventProducer {
    private static final BundleLogger LOGGER = BundleLoggerFactory.getLogger(SpatialFieldEnricherProcessor.class);
    public static final String P_RESULT_MAX_SIZE = "maxResultSize";
    public static final String P_MAX_CACHE_SIZE = "maxCacheSize";
    public static final String P_CACHE_REFRESH_TIME_INTERVAL = "cacheRefreshTimeInterval";
    public static final String P_EVENT_JOIN_FIELD_NAME = "eventJoinFieldName";
    public static final String P_DS_JOIN_FIELD_NAME = "dataJoinFieldName";
    public static final String P_WHERE_CLAUSE = "whereClause";
    public static final String P_SPATIAL_RELATIONSHIP = "spatialRelationship";
    public static final String P_OUT_DEF_NAME = "eventDefinitionName";
    public static final String P_ENRICH_TAGS = "tags";
    public static final String P_ENRICH_FIELDS = "fields";
    public static final String P_RESULT_DESTINATION = "resultDestination";
    public static final String P_DS_SERVICE_TYPE = "serverType";
    public static final String P_DS_NAME = "dataStoreName";
    public static final String P_DS_FOLDER = "folder";
    public static final String P_DS_SERVICE = "service";
    public static final String P_DS_LAYER = "layer";
    public static final String P_BUFFER_DIST = "bufferDist";
    public static final String P_BUFFER_UNITS = "bufferUnits";
    private Messaging messaging;
    private GeoEventProducer geoEventProducer;
    private GeoEventCreator geoEventCreator;
    protected GeoEventDefinitionManager geoEventDefinitionManager;
    protected TagManager tagManager;
    Map<String, GeoEventProducer> producerMap = new HashMap<String, GeoEventProducer>();
    protected FeatureServiceQueryDataProvider dataProvider;
    protected Map<String, String> edMapper = new ConcurrentHashMap<String, String>();
    protected Map<Integer, String> tags = new ConcurrentHashMap<Integer, String>();
    protected ResultDestination resultDestination = (ResultDestination)Validator.valueOfIgnoreCase(ResultDestination.class, (String)this.getProperty("resultDestination").getValueAsString(), (Enum)ResultDestination.NEW_FIELDS);

    protected SpatialFieldEnricherProcessor(GeoEventProcessorDefinition definition) throws ComponentException {
        super(definition);
        if (ResultDestination.NEW_FIELDS.equals((Object)this.resultDestination)) {
            this.geoEventMutator = false;
            String[] tags = Validator.compactSpaces((String)this.getProperty(P_ENRICH_TAGS).getValueAsString()).split(",");
            int i = 0;
            String[] stringArray = tags;
            int n = tags.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                String tagName = Validator.compactWhiteSpaces((String)s);
                if (!tagName.isEmpty() && Validator.isValidTagName((String)tagName)) {
                    this.tags.put(i, tagName);
                }
                ++i;
                ++n2;
            }
        } else {
            this.geoEventMutator = true;
        }
        LOGGER.error("Constructed Spatial Query Field Enricher");
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        this.resultDestination = (ResultDestination)Validator.valueOfIgnoreCase(ResultDestination.class, (String)this.getProperty(P_RESULT_DESTINATION).getValueAsString(), (Enum)ResultDestination.NEW_FIELDS);
        if (ResultDestination.NEW_FIELDS.equals((Object)this.resultDestination)) {
            this.geoEventMutator = false;
            String[] tags = Validator.compactSpaces((String)this.getProperty(P_ENRICH_TAGS).getValueAsString()).split(",");
            int i = 0;
            String[] stringArray = tags;
            int n = tags.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                String tagName = Validator.compactWhiteSpaces((String)s);
                if (!tagName.isEmpty() && Validator.isValidTagName((String)tagName)) {
                    this.tags.put(i, tagName);
                }
                ++i;
                ++n2;
            }
        } else {
            this.geoEventMutator = true;
        }
        FeatureServiceQueryDataProvider dp = this.dataProvider;
        dp.setArcGISServerType((ArcGISServerType)Validator.valueOfIgnoreCase(ArcGISServerType.class, (String)this.getProperty(P_DS_SERVICE_TYPE).getValueAsString(), (Enum)ArcGISServerType.FeatureServer));
        dp.setArcGISServerConnectionName(this.getProperty(P_DS_NAME).getValueAsString());
        dp.setFolder(this.getProperty(P_DS_FOLDER).getValueAsString());
        dp.setDataSourceName(this.getProperty(P_DS_SERVICE).getValueAsString());
        dp.setLayer(this.getProperty(P_DS_LAYER).getValueAsString());
        dp.setEventJoinFieldName(this.getProperty(P_EVENT_JOIN_FIELD_NAME).getValueAsString());
        dp.setFields(this.getProperty(P_ENRICH_FIELDS).getValueAsString());
        dp.setOutputGeoEventDefinitionName(this.getProperty(P_OUT_DEF_NAME).getValueAsString());
        dp.setMaxCacheSize((Integer)this.getProperty(P_MAX_CACHE_SIZE).getValue());
        dp.setExpiryTime((Integer)this.getProperty(P_CACHE_REFRESH_TIME_INTERVAL).getValue());
        dp.setWhereClause(this.getProperty(P_WHERE_CLAUSE).getValueAsString());
        dp.setResultMaxSize(Integer.valueOf(this.getProperty(P_RESULT_MAX_SIZE).getValueAsString()));
        dp.setSpatialRelationship(SpatialRelations.fromString(this.getProperty(P_SPATIAL_RELATIONSHIP).getValueAsString()));
        dp.setBuffer_dist(Double.valueOf(this.getProperty(P_BUFFER_DIST).getValueAsString()));
        dp.setBuffer_unit(SpatialUnits.fromString(this.getProperty(P_BUFFER_UNITS).getValueAsString()));
        LOGGER.error("After properties set");
    }

    public synchronized void validate() throws ValidationException {
        super.validate();
        if (this.dataProvider == null) {
            throw new ValidationException(LOGGER.translate("NULL_DATA_PROVIDER"));
        }
        this.dataProvider.validate();
    }

    public void shutdown() {
        super.shutdown();
        if (this.dataProvider != null) {
            this.dataProvider.shutdown();
            this.dataProvider = null;
        }
        this.clearGeoEventDefinitionMapper();
    }

    public GeoEvent process(GeoEvent geoEvent) throws Exception {
        long start = System.currentTimeMillis();
        GeoEvent result = null;
        LOGGER.error("process {0}", new Object[]{geoEvent});
        if (geoEvent != null && this.geoEventDefinitionManager != null) {
            LOGGER.error("Processing {0} {1}", new Object[]{geoEvent, this.geoEventDefinitionManager});
            Object[] features = this.dataProvider.getData(geoEvent);
            if (features != null) {
                LOGGER.error("Got features of length {0}", new Object[]{features.length});
                int f = 0;
                while (f < features.length) {
                    LOGGER.error("Working on feature index {0}", new Object[]{f});
                    Object[] fieldsToAugment = (Object[])features[f];
                    LOGGER.error("Feature at index {0} has {1} field values", new Object[]{f, fieldsToAugment.length});
                    if (fieldsToAugment != null && fieldsToAugment.length > 0) {
                        LOGGER.error("Augmenting event with fields");
                        try {
                            GeoEvent geoEventOut;
                            GeoEventDefinition gedIn = geoEvent.getGeoEventDefinition();
                            LOGGER.error("GED In {0}", new Object[]{gedIn});
                            if (ResultDestination.NEW_FIELDS.equals((Object)this.resultDestination)) {
                                LOGGER.error("Creating new geoevent definition (new fields)");
                                geoEventOut = this.geoEventCreator.create(this.lookup(gedIn).getGuid(), new Object[]{geoEvent.getAllFields(), fieldsToAugment});
                                geoEventOut.setProperty(GeoEventPropertyName.TYPE, (Object)"message");
                                geoEventOut.setProperty(GeoEventPropertyName.OWNER_ID, (Object)this.getId());
                                geoEventOut.setProperty(GeoEventPropertyName.OWNER_URI, (Object)this.definition.getUri());
                                for (Map.Entry property : geoEvent.getProperties()) {
                                    if (geoEventOut.hasProperty((GeoEventPropertyName)property.getKey())) continue;
                                    geoEventOut.setProperty((GeoEventPropertyName)property.getKey(), property.getValue());
                                }
                                result = geoEventOut;
                                this.send(geoEventOut);
                            } else {
                                LOGGER.error("Creating new geoevent definition (existing fields)");
                                geoEventOut = this.geoEventCreator.create(gedIn.getGuid(), new Object[]{geoEvent.getAllFields()});
                                FieldDefinition[] fdsIn = gedIn.getFieldDefinitionsArray();
                                int i = 0;
                                for (FieldDefinition fd : this.dataProvider.getFieldDefinitions()) {
                                    int j = gedIn.getIndexOf(fd.getName());
                                    if (j != -1) {
                                        Object value;
                                        switch (fdsIn[j].getType()) {
                                            case Date: {
                                                value = Converter.convertToDate((Object)fieldsToAugment[i]);
                                                break;
                                            }
                                            case Double: {
                                                value = Converter.convertToDouble((Object)fieldsToAugment[i]);
                                                break;
                                            }
                                            case Float: {
                                                value = Converter.convertToFloat((Object)fieldsToAugment[i]);
                                                break;
                                            }
                                            case Integer: {
                                                value = Converter.convertToInteger((Object)fieldsToAugment[i]);
                                                break;
                                            }
                                            case Long: {
                                                value = Converter.convertToLong((Object)fieldsToAugment[i]);
                                                break;
                                            }
                                            case Short: {
                                                value = Converter.convertToShort((Object)fieldsToAugment[i]);
                                                break;
                                            }
                                            case Boolean: {
                                                value = Converter.convertToBoolean((Object)fieldsToAugment[i]);
                                                break;
                                            }
                                            case Geometry: {
                                                value = Converter.convertToGeometry((Object)fieldsToAugment[i]);
                                                break;
                                            }
                                            default: {
                                                value = Converter.convertToString((Object)fieldsToAugment[i]);
                                            }
                                        }
                                        if (value != null) {
                                            geoEventOut.setField(j, geoEventOut.cloneField(value, fdsIn[j]));
                                        }
                                    }
                                    ++i;
                                }
                                result = geoEventOut;
                                result.setProperty(GeoEventPropertyName.TYPE, (Object)"event");
                                this.send(geoEventOut);
                            }
                        }
                        catch (ConfigurationException | FieldException | GeoEventDefinitionManagerException | MessagingException e) {
                            LOGGER.error("FAILED_TO_ENRICH_GED", new Object[]{geoEvent.getGeoEventDefinition().getGuid(), e.getMessage()});
                        }
                    }
                    ++f;
                }
            }
        }
        LOGGER.error("Processed event in {0} ms", new Object[]{System.currentTimeMillis() - start});
        return result;
    }

    public SpatialFieldEnricherProcessor setMessaging(Messaging messaging) {
        this.messaging = messaging;
        this.geoEventCreator = messaging.createGeoEventCreator();
        LOGGER.trace("Set GeoEvent Messaging and created GeoEvent Creator");
        return this;
    }

    public void send(GeoEvent geoEvent) throws MessagingException {
        if (geoEvent != null) {
            String destinationId = String.valueOf(this.getId()) + ":event";
            LOGGER.error("Getting producer {0}", new Object[]{destinationId});
            GeoEventProducer producer = this.producerMap.get(destinationId);
            if (producer == null) {
                EventDestination eventDestination = new EventDestination(destinationId, this.getLabel());
                producer = this.messaging.createGeoEventProducer(eventDestination);
                this.producerMap.put(destinationId, producer);
                LOGGER.error("created GeoEvent Producer for destination id {0}", new Object[]{destinationId});
            }
            this.geoEventProducer = producer;
            LOGGER.error("Trying to send {0} on producer {1}", new Object[]{geoEvent, destinationId});
            if (this.geoEventProducer != null) {
                if (this.geoEventProducer.isConnected()) {
                    LOGGER.error("Producer {0} is connected!", new Object[]{destinationId});
                } else {
                    LOGGER.error("Producer {0} is NOT connected!", new Object[]{destinationId});
                }
                LOGGER.error("Sending {0} on producer {1}", new Object[]{geoEvent, destinationId});
                this.geoEventProducer.send(geoEvent);
            } else {
                LOGGER.error("Producer {0} is NULL!", new Object[]{destinationId});
            }
        }
    }

    public EventDestination getEventDestination() {
        LOGGER.error("getEventDestination {0}", new Object[]{this.geoEventProducer != null ? this.geoEventProducer.getEventDestination() : null});
        return this.geoEventProducer != null ? this.geoEventProducer.getEventDestination() : null;
    }

    public List<EventDestination> getEventDestinations() {
        LOGGER.error("getEventDestination {0}", new Object[]{this.geoEventProducer != null ? Arrays.asList(this.geoEventProducer.getEventDestination()) : new ArrayList()});
        return this.geoEventProducer != null ? Arrays.asList(this.geoEventProducer.getEventDestination()) : new ArrayList<EventDestination>();
    }

    public void disconnect() {
        LOGGER.error("Disconnect");
        if (this.geoEventProducer != null) {
            this.geoEventProducer.disconnect();
        }
    }

    public boolean isConnected() {
        LOGGER.error("Is Connected = {0}", new Object[]{this.geoEventProducer != null ? this.geoEventProducer.isConnected() : false});
        return this.geoEventProducer != null ? this.geoEventProducer.isConnected() : false;
    }

    public String getStatusDetails() {
        LOGGER.error("Get Status {0}", new Object[]{this.geoEventProducer != null ? this.geoEventProducer.getStatusDetails() : ""});
        return this.geoEventProducer != null ? this.geoEventProducer.getStatusDetails() : "";
    }

    public void setup() throws MessagingException {
        LOGGER.error("Setup");
    }

    public void init() throws MessagingException {
        LOGGER.error("Init");
    }

    public void update(Observable o, Object arg) {
        LOGGER.error("Update");
    }

    public void onServiceStop() {
        if (this.dataProvider != null) {
            this.dataProvider.clearCache();
        }
    }

    private void tag(FieldDefinition fd, String tagName) {
        List types;
        Tag tag = this.tagManager.getTag(tagName);
        if (tag != null && (types = tag.getTypes()) != null && types.indexOf(fd.getType().toString()) != -1) {
            fd.addTag(tag.getName());
        }
    }

    protected synchronized GeoEventDefinition lookup(GeoEventDefinition gedIn) throws ConfigurationException, GeoEventDefinitionManagerException {
        List<FieldDefinition> fds;
        GeoEventDefinition gedOut;
        GeoEventDefinition geoEventDefinition = gedOut = this.edMapper.containsKey(gedIn.getGuid()) ? this.geoEventDefinitionManager.getGeoEventDefinition(this.edMapper.get(gedIn.getGuid())) : null;
        if (gedOut == null && (fds = this.dataProvider.getFieldDefinitions()) != null && fds.size() > 0) {
            String edName;
            int i = 0;
            for (FieldDefinition fd : fds) {
                if (this.tags.containsKey(i)) {
                    this.tag(fd, this.tags.get(i));
                }
                ++i;
            }
            gedOut = gedIn.augment(fds);
            gedOut.setOwner(this.getLabel());
            String string = edName = this.hasProperty(P_OUT_DEF_NAME) ? this.getProperty(P_OUT_DEF_NAME).getValueAsString().trim() : "";
            if (!edName.isEmpty()) {
                gedOut.setName(edName);
                this.geoEventDefinitionManager.addTemporaryGeoEventDefinition(gedOut, false);
            } else {
                this.geoEventDefinitionManager.addTemporaryGeoEventDefinition(gedOut, true);
            }
            this.edMapper.put(gedIn.getGuid(), gedOut.getGuid());
        }
        return gedOut;
    }

    private synchronized void clearGeoEventDefinitionMapper() {
        if (!this.edMapper.isEmpty()) {
            for (String guid : this.edMapper.values()) {
                try {
                    this.geoEventDefinitionManager.deleteGeoEventDefinition(guid);
                }
                catch (GeoEventDefinitionManagerException e) {
                    LOGGER.warn("FAILED_TO_DELETE_GED", new Object[]{guid, e.getMessage()});
                }
            }
            this.edMapper.clear();
        }
    }

    public Object addingService(ServiceReference serviceReference) {
        Object service = this.definition.getBundleContext().getService(serviceReference);
        if (service instanceof GeoEventDefinitionManager) {
            this.geoEventDefinitionManager = (GeoEventDefinitionManager)service;
        }
        return service;
    }

    public void modifiedService(ServiceReference serviceReference, Object service) {
    }

    public void removedService(ServiceReference serviceReference, Object service) {
        if (service instanceof GeoEventDefinitionManager) {
            this.clearGeoEventDefinitionMapper();
            this.geoEventDefinitionManager = null;
        }
    }

    public void setDataProvider(FeatureServiceQueryDataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    public void setGeoEventCreator(GeoEventCreator geoEventCreator) {
        this.geoEventCreator = geoEventCreator;
        this.geoEventDefinitionManager = geoEventCreator.getGeoEventDefinitionManager();
    }

    public void setTagManager(TagManager tagManager) {
        this.tagManager = tagManager;
    }

    private String findGuidFromName(String edName) {
        Collection inResults = this.geoEventDefinitionManager.searchGeoEventDefinitionByName(edName);
        return inResults.isEmpty() ? null : ((GeoEventDefinition)inResults.iterator().next()).getGuid();
    }

    public boolean isCacheRequired() {
        return false;
    }

    public synchronized void setProperty(Property property) throws PropertyException {
        if (!P_DS_JOIN_FIELD_NAME.equals(property.getName())) {
            super.setProperty(property);
        }
    }
}

