/*
 * Decompiled with CFR 0.152.
 */
package com.esri.geoevent.processor.spatialfieldenricher;

import com.esri.ges.framework.i18n.BundleLogger;
import com.esri.ges.framework.i18n.BundleLoggerFactory;
import com.esri.ges.util.Validator;

public enum ResultDestination {
    EXISTING_FIELDS,
    NEW_FIELDS;

    private static final BundleLogger LOGGER;

    static {
        LOGGER = BundleLoggerFactory.getLogger(ResultDestination.class);
    }

    public String toString() {
        switch (this) {
            case EXISTING_FIELDS: {
                return "Existing Fields";
            }
            case NEW_FIELDS: {
                return "New Fields";
            }
        }
        return "";
    }

    public static ResultDestination fromString(String s) throws IllegalArgumentException {
        String name = Validator.compactWhiteSpaces((String)s);
        if (!name.isEmpty()) {
            if ("Existing Fields".equals(name)) {
                return EXISTING_FIELDS;
            }
            if ("New Fields".equals(name)) {
                return NEW_FIELDS;
            }
        }
        throw new IllegalArgumentException(LOGGER.translate("INVALID_RESULT_DESTINATION_ENUM", new Object[]{name}));
    }
}

