/*
 * Decompiled with CFR 0.152.
 */
package com.esri.geoevent.processor.spatialfieldenricher;

import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryEngine;
import com.esri.core.geometry.MapGeometry;
import com.esri.core.geometry.SpatialReference;
import com.esri.geoevent.processor.spatialfieldenricher.SpatialRelations;
import com.esri.geoevent.processor.spatialfieldenricher.SpatialUnits;
import com.esri.ges.core.ConfigurationException;
import com.esri.ges.core.geoevent.FieldDefinition;
import com.esri.ges.core.geoevent.FieldType;
import com.esri.ges.core.geoevent.GeoEvent;
import com.esri.ges.core.geoevent.GeoEventDefinition;
import com.esri.ges.core.http.GeoEventHttpClient;
import com.esri.ges.core.http.GeoEventHttpClientService;
import com.esri.ges.core.http.KeyValue;
import com.esri.ges.core.http.KeyValueList;
import com.esri.ges.core.validation.ValidationException;
import com.esri.ges.datastore.DataStoreException;
import com.esri.ges.framework.i18n.BundleLogger;
import com.esri.ges.framework.i18n.BundleLoggerFactory;
import com.esri.ges.manager.datastore.agsconnection.ArcGISServerConnection;
import com.esri.ges.manager.datastore.agsconnection.ArcGISServerConnectionManager;
import com.esri.ges.manager.datastore.agsconnection.ArcGISServerConnectionStatus;
import com.esri.ges.manager.datastore.agsconnection.ArcGISServerConnectionStatusListener;
import com.esri.ges.manager.datastore.agsconnection.ArcGISServerType;
import com.esri.ges.manager.datastore.agsconnection.Layer;
import com.esri.ges.util.DateUtil;
import com.esri.ges.util.Validator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class FeatureServiceQueryDataProvider
implements ArcGISServerConnectionStatusListener {
    private static final BundleLogger LOGGER = BundleLoggerFactory.getLogger(FeatureServiceQueryDataProvider.class);
    public static final String D_WHERE_CLAUSE = "1=1";
    public static final int D_RESULT_MAX_SIZE = 1;
    public static final SpatialRelations D_SPAT_REL = SpatialRelations.Intersects;
    protected static final int defaultTimeout = 30000;
    private GeoEventHttpClientService httpClientService;
    protected ArcGISServerConnectionManager arcGISServerConnectionManager;
    protected ArcGISServerConnection arcGISServerConnection;
    protected String folder;
    protected String layerIdOrName;
    protected Layer layer;
    protected String outputGeoEventDefinitionName;
    protected Map<String, Integer> fieldIndex = new HashMap<String, Integer>();
    protected String arcGISServerConnectionName;
    protected String arcGISServerConnectionLabel;
    protected ArcGISServerType arcGISServerType;
    private int maxCacheSize = 1000;
    protected Map<Object, ExpirableData> cache = Collections.synchronizedMap(new LruLinkedHashMap(1000));
    private long expiryTime = 0L;
    private ObjectMapper mapper = new ObjectMapper();
    protected String dataSourceName;
    protected String eventJoinFieldName;
    protected String dataJoinFieldName;
    protected List<String> fields = new ArrayList<String>();
    protected List<FieldDefinition> fieldDefs = new ArrayList<FieldDefinition>();
    protected List<FieldDefinition> fieldDefsSelected = new ArrayList<FieldDefinition>();
    private String whereClause = "1=1";
    private int resultMaxSize = 1;
    private SpatialRelations spatialRelationship = D_SPAT_REL;
    private double buffer_dist = 0.0;
    private SpatialUnits buffer_unit = SpatialUnits.esriSRUnit_Foot;

    public FeatureServiceQueryDataProvider(ArcGISServerConnectionManager manager, GeoEventHttpClientService httpClientService) {
        this.arcGISServerConnectionManager = manager;
        this.arcGISServerConnectionName = "";
        this.folder = "";
        this.dataSourceName = "";
        this.layerIdOrName = "";
        this.layer = null;
        this.outputGeoEventDefinitionName = null;
        this.arcGISServerType = ArcGISServerType.FeatureServer;
        this.httpClientService = httpClientService;
    }

    public synchronized void validate() throws ValidationException {
        if (this.arcGISServerConnectionManager == null) {
            throw new ValidationException(LOGGER.translate("NULL_AGS_CONNECTION_MANAGER"));
        }
        this.arcGISServerConnection = this.arcGISServerConnectionManager.getArcGISServerConnection(this.arcGISServerConnectionName);
        if (this.arcGISServerConnection == null) {
            throw new ValidationException(LOGGER.translate("AGS_CONNECTION_DOESNT_EXIST", new Object[]{this.arcGISServerConnectionLabel}));
        }
        if (!this.isFolderExist()) {
            throw new ValidationException(LOGGER.translate("AGS_FOLDER_DOESNT_EXIST", new Object[]{this.arcGISServerConnectionLabel, this.folder}));
        }
        if (!this.isServiceExist()) {
            throw new ValidationException(LOGGER.translate("AGS_SERVICE_DOESNT_EXIST", new Object[]{this.arcGISServerConnectionLabel, this.dataSourceName, this.folder}));
        }
        try {
            if (this.arcGISServerConnection.initialUpdateCompleted()) {
                this.getLayerInformation(false);
            }
            this.arcGISServerConnectionManager.registerArcGISServerConnectionListener(this.arcGISServerConnectionName, (ArcGISServerConnectionStatusListener)this);
        }
        catch (Exception e) {
            this.shutdown();
            throw new ValidationException(LOGGER.translate("FAILED_TO_CREATE_GED_FOR_AGS_LAYER", new Object[]{this.arcGISServerConnectionLabel, this.layer == null ? this.layerIdOrName : this.layer.getName(), this.dataSourceName, this.folder, e.getMessage()}));
        }
    }

    public Object[] getData(GeoEvent geoEvent) {
        long start = System.currentTimeMillis();
        LOGGER.error("getData {0}", new Object[]{geoEvent});
        Object[] data = null;
        Object value = geoEvent.getField(this.eventJoinFieldName);
        LOGGER.error("geoEvent.getField( {0} ) = {1}", new Object[]{this.eventJoinFieldName, value});
        if (value == null) {
            LOGGER.error("Geometry is null, cannot perform spatial query");
        } else {
            MapGeometry geo = (MapGeometry)value;
            LOGGER.error("Geometry = {0}", new Object[]{geo});
            value = GeometryEngine.geometryToJson((SpatialReference)geo.getSpatialReference(), (Geometry)geo.getGeometry());
            LOGGER.error("Value = {0}", new Object[]{geo});
            ExpirableData expirableData = null;
            if (expirableData == null) {
                LOGGER.error("Getting new data from service");
                try {
                    data = this.getData(geoEvent, geo);
                    LOGGER.error("Data returned = " + data);
                    if (data != null) {
                        expirableData = new ExpirableData(data);
                        LOGGER.error("expirableData = {0}", new Object[]{expirableData});
                        this.cache.put(value, expirableData);
                    }
                }
                catch (DataStoreException e) {
                    LOGGER.error("EXCEPTION_PARSING_DATA", new Object[]{e.getMessage()});
                    LOGGER.info(e.getMessage(), (Throwable)e);
                }
                catch (IOException e) {
                    LOGGER.error("EXCEPTION_PARSING_DATA", new Object[]{e.getMessage()});
                    LOGGER.info(e.getMessage(), (Throwable)e);
                }
            }
            if (expirableData != null) {
                data = expirableData.getData();
                LOGGER.error("expirableData.getData = {0}", data);
            } else {
                LOGGER.error("expirableData == null");
            }
        }
        LOGGER.error("RETURN Data = {0} in {1} ms", new Object[]{data, System.currentTimeMillis() - start});
        return data;
    }

    private Object[] getData(GeoEvent geoevent, MapGeometry geometryFilter) throws DataStoreException, IOException {
        LOGGER.error("getData Map Geometry = {0}", new Object[]{geometryFilter});
        if (this.arcGISServerConnection == null) {
            throw new DataStoreException(LOGGER.translate("LOST_DATASTORE", new Object[]{this.arcGISServerConnectionLabel}));
        }
        if (this.layer == null) {
            LOGGER.info("NEED_TO_FETCH_LAYERID", new Object[]{this.arcGISServerConnection.getLabel(), this.layerIdOrName});
            try {
                this.getLayerInformation(false);
            }
            catch (ConfigurationException | ValidationException ve) {
                LOGGER.debug(ve.getMessage(), ve);
                throw new DataStoreException(ve.getMessage());
            }
        } else {
            LOGGER.error("Query Layer: {0}", new Object[]{this.layer});
        }
        List<Map.Entry<String, String>[]> items = this.getFeatureAttributesBySpatial(geoevent, geometryFilter);
        ArrayList result = new ArrayList();
        items.stream().forEach(feature -> {
            if (((Map.Entry[])feature).length > 0) {
                LOGGER.error("Working on feature {0}", new Object[]{feature.toString()});
                List<FieldDefinition> attDefs = this.getFieldDefinitions();
                Object[] data = new Object[attDefs.size()];
                int i = 0;
                Map.Entry[] entryArray = feature;
                int n = ((Map.Entry[])feature).length;
                int n2 = 0;
                while (n2 < n) {
                    Map.Entry keyValue = entryArray[n2];
                    FieldDefinition attDef = attDefs.get(i);
                    if (attDef.getType() == FieldType.Date) {
                        String dateValue = (String)keyValue.getValue();
                        if (dateValue != null) {
                            data[i] = DateUtil.convert((String)dateValue);
                        }
                    } else {
                        data[i] = attDef.validateValue(keyValue.getValue());
                    }
                    LOGGER.error("   Feature attribute {0} == {1}", new Object[]{i, data[i]});
                    ++i;
                    ++n2;
                }
                LOGGER.error("Adding to results a feature list of size {0}", new Object[]{data.length});
                result.add(data);
            }
        });
        LOGGER.error("Returning result list of size {0}", new Object[]{result.size()});
        return result.size() > 0 ? result.toArray(new Object[result.size()]) : null;
    }

    private List<Map.Entry<String, String>[]> getFeatureAttributesBySpatial(GeoEvent geoevent, MapGeometry geometryFilter) throws IOException {
        LOGGER.error("Getting features by spatial query");
        HashMap<String, String> kvParams = new HashMap<String, String>();
        String formattedWhere = geoevent.formatString(this.whereClause);
        LOGGER.info("Using where clause: {0}", new Object[]{this.whereClause});
        LOGGER.info("Using formatted where clause: {0}", new Object[]{formattedWhere});
        kvParams.put("query", this.whereClause);
        kvParams.put("where", formattedWhere);
        kvParams.put("geometry", "-105.15265104599996,39.91072123300006");
        kvParams.put("geometryType", "esriGeometry" + geometryFilter.getGeometry().getType().toString());
        kvParams.put("inSR", "" + geometryFilter.getSpatialReference().getID());
        kvParams.put("spatialRel", this.spatialRelationship.toString());
        kvParams.put("distance", Double.toString(this.buffer_dist));
        kvParams.put("units", this.buffer_unit.toString());
        kvParams.put("outFields", this.getFields());
        kvParams.put("returnGeometry", this.isJoinGeometryField() ? "TRUE" : "FALSE");
        kvParams.put("returnDistinctValues", "FALSE");
        kvParams.put("returnIdsOnly", "FALSE");
        kvParams.put("returnCountOnly", "FALSE");
        kvParams.put("returnExtentOnly", "FALSE");
        kvParams.put("returnZ", "FALSE");
        kvParams.put("returnM", "FALSE");
        kvParams.put("multipatchOption", "xyFootprint");
        kvParams.put("resultOffset", "0");
        kvParams.put("resultRecordCount", "" + this.resultMaxSize);
        kvParams.put("returnTrueCurves", "FALSE");
        kvParams.put("returnExceededLimitFeatures", "FALSE");
        kvParams.put("returnCentroid", "FALSE");
        kvParams.put("sqlFormat", "none");
        kvParams.put("f", "json");
        LOGGER.error("Getting features by spatial query with kvParams {0}", new Object[]{kvParams});
        KeyValueList params = new KeyValueList();
        kvParams.keySet().forEach(key -> params.add(new KeyValue(key, (String)kvParams.get(key))));
        StringBuilder path = new StringBuilder(this.arcGISServerConnection.getUrl().toString());
        path.append("rest/services/");
        if (this.folder != null && !this.folder.isEmpty()) {
            path.append(this.folder);
        }
        path.append("/");
        path.append(this.dataSourceName);
        path.append("/");
        path.append(this.arcGISServerType);
        path.append("/");
        path.append(this.layer.getId());
        path.append("/query");
        URL url = new URL(path.toString());
        LOGGER.error("Using REST URL: {0}", new Object[]{url});
        List<JsonNode> jsonNodeList = this.getAllFeatures(url, params, 30000);
        LOGGER.error("Got jsonNode response {0}", new Object[]{jsonNodeList});
        HashMap<String, Integer> fieldIndexes = new HashMap<String, Integer>();
        int ix = 0;
        String[] stringArray = this.getFields().split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            if (!(field = field.trim()).isEmpty() && !fieldIndexes.containsKey(field)) {
                fieldIndexes.put(field, ix++);
            }
            ++n2;
        }
        ArrayList<Map.Entry<String, String>[]> featureList = new ArrayList<Map.Entry<String, String>[]>();
        jsonNodeList.stream().forEach(json -> {
            LOGGER.error("Json Node Response: {0}", new Object[]{json});
            String sr = "";
            ObjectNode srNode = (ObjectNode)json.get("spatialReference");
            if (srNode != null) {
                Iterator i = srNode.fields();
                while (i.hasNext()) {
                    Map.Entry srEntry = (Map.Entry)i.next();
                    if ("wkid".equals(srEntry.getKey())) {
                        sr = "\"spatialReference\" : {\"wkid\" : " + ((JsonNode)srEntry.getValue()).asText() + " }";
                        break;
                    }
                    if (!"wkt".equals(srEntry.getKey())) continue;
                    sr = "\"spatialReference\" : {\"wkt\" : \"" + ((JsonNode)srEntry.getValue()).asText().replaceAll("\"", "") + "\"}";
                    break;
                }
            }
            int featureIndex = 0;
            for (JsonNode feature : json.get("features")) {
                if (featureList.size() >= this.resultMaxSize) continue;
                LOGGER.error("Processing feature: {0}", new Object[]{feature});
                Map.Entry[] featureAttributeKeyValueArray = null;
                StringBuffer featureGeometry = new StringBuffer();
                Iterator i = feature.fields();
                while (i.hasNext()) {
                    Map.Entry featureEntry = (Map.Entry)i.next();
                    LOGGER.error("  Processing feature entry: {0}", new Object[]{featureEntry});
                    if (!(featureEntry.getValue() instanceof ObjectNode)) continue;
                    ObjectNode node = (ObjectNode)featureEntry.getValue();
                    LOGGER.error("    Processing feature entry node: {0}", new Object[]{node});
                    if ("geometry".equals(featureEntry.getKey())) {
                        featureGeometry.append(node.toString().substring(0, node.toString().indexOf("}"))).append(",").append(sr).append("}");
                        if (!fieldIndexes.containsKey("geometry")) continue;
                        featureAttributeKeyValueArray[((Integer)map.get((Object)"geometry")).intValue()] = new AbstractMap.SimpleEntry<String, String>("geometry", featureGeometry.toString());
                        continue;
                    }
                    if (!"attributes".equals(featureEntry.getKey())) continue;
                    featureAttributeKeyValueArray = new Map.Entry[fieldIndexes.size()];
                    Iterator j = node.fields();
                    while (j.hasNext()) {
                        Map.Entry attribute = (Map.Entry)j.next();
                        LOGGER.error("      Processing feature entry node attribute: {0}", new Object[]{attribute});
                        if (!fieldIndexes.containsKey(attribute.getKey())) continue;
                        featureAttributeKeyValueArray[((Integer)map.get(attribute.getKey())).intValue()] = new AbstractMap.SimpleEntry<String, Object>((String)attribute.getKey(), (((JsonNode)attribute.getValue()).isNull() ? null : ((JsonNode)attribute.getValue()).asText()));
                        LOGGER.error("        Set KeyValues for pair:  {0}", new Object[]{featureAttributeKeyValueArray[(Integer)fieldIndexes.get(attribute.getKey())]});
                    }
                }
                featureList.add(featureAttributeKeyValueArray);
                LOGGER.error("featureList size = {0}. featureList = {1}", new Object[]{featureList.size(), featureList});
                if (++featureIndex < this.resultMaxSize) continue;
                LOGGER.error("featureList size = {0} matches the maximum result set size {1}. Not processing any more data.", new Object[]{featureList.size(), this.resultMaxSize});
                break;
            }
        });
        List<Object> result = featureList;
        LOGGER.error("Got feature list of size {0}", new Object[]{featureList.size()});
        if (featureList.size() > this.resultMaxSize) {
            LOGGER.error("Trimming feature list of size {0} to ", new Object[]{featureList.size(), this.resultMaxSize});
            result = featureList.subList(0, this.resultMaxSize);
        }
        LOGGER.error("Returning list of features of size {0}", new Object[]{result.size()});
        return result;
    }

    private List<JsonNode> getAllFeatures(URL url, KeyValueList baseParams, int defaultTimeout) throws IOException {
        ObjectNode responseNode;
        ArrayList<JsonNode> output = new ArrayList<JsonNode>();
        String responseString = "";
        JsonNode node = null;
        try {
            Throwable throwable = null;
            Object var10_10 = null;
            try (GeoEventHttpClient http = this.httpClientService.createNewClient();){
                long start = System.currentTimeMillis();
                responseString = http.get(url, baseParams, defaultTimeout);
                LOGGER.info("Got response in {0} ms: {1}", new Object[]{System.currentTimeMillis() - start, responseString});
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LOGGER.debug("", (Throwable)e);
        }
        node = this.getFeaturesFromResponses(responseString, url);
        Object object = responseNode = node == null ? this.mapper.createObjectNode() : this.mapper.readTree(responseString);
        if (node == null || node.size() == 0) {
            return output;
        }
        List<Long> allOids = this.getAllObjectIds(url, baseParams, defaultTimeout);
        if (node.size() < allOids.size()) {
            int numPerQuery = node.size();
            int index = 0;
            while (index < allOids.size()) {
                String oids = this.arrayToString(allOids, index, numPerQuery);
                KeyValueList newParams = this.getQueryParametersWithObjectIds(baseParams, oids);
                try {
                    Throwable throwable = null;
                    Object var14_21 = null;
                    try (GeoEventHttpClient http = this.httpClientService.createNewClient();){
                        responseString = http.get(url, newParams, defaultTimeout);
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    LOGGER.debug("", (Throwable)e);
                }
                if (responseString != null) {
                    output.add(this.mapper.readTree(responseString));
                }
                index += numPerQuery;
            }
        } else {
            output.add((JsonNode)responseNode);
        }
        return output;
    }

    private String arrayToString(List<Long> array, int from, int count) {
        String output = "";
        StringBuilder sb = new StringBuilder();
        int end = from + count > array.size() ? array.size() : from + count;
        int i = from;
        while (i < end) {
            sb.append(array.get(i)).append(",");
            ++i;
        }
        output = sb.toString();
        if (output.endsWith(",")) {
            output = output.substring(0, output.length() - 1);
        }
        return output;
    }

    private KeyValueList getQueryParametersWithObjectIds(KeyValueList baseParams, String oids) {
        KeyValueList newParams = new KeyValueList();
        newParams.addAll(baseParams);
        newParams.add(new KeyValue("objectIds", oids));
        return newParams;
    }

    private JsonNode getFeaturesFromResponses(String responseString, URL url) throws JsonProcessingException, IOException {
        JsonNode output = null;
        if (responseString != null) {
            JsonNode response = this.mapper.readTree(responseString);
            if (response.has("features")) {
                output = response.get("features");
            } else if (response.has("error")) {
                String errorMessage = LOGGER.translate("AGS_ERROR_ACCESSING_DS", new Object[]{url});
                JsonNode error = response.get("error");
                if (error.has("code")) {
                    errorMessage = String.valueOf(errorMessage) + " : " + error.get("code").asInt();
                }
                if (error.has("message")) {
                    errorMessage = String.valueOf(errorMessage) + " : " + error.get("message").asText();
                }
                throw new IOException(errorMessage);
            }
        }
        return output;
    }

    private List<Long> getAllObjectIds(URL url, KeyValueList baseParams, int defaultTimeout) throws IOException {
        ArrayList<Long> output = new ArrayList<Long>();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (GeoEventHttpClient http = this.httpClientService.createNewClient();){
                JsonNode response;
                KeyValueList newParams = this.getQueryParametersWithObjectIdOnly(baseParams);
                String responseString = http.get(url, newParams, defaultTimeout);
                if (responseString != null && (response = this.mapper.readTree(responseString)).has("objectIds")) {
                    for (JsonNode oid : response.get("objectIds")) {
                        output.add(Long.parseLong(oid.asText()));
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable t) {
            LOGGER.error("", t);
        }
        return output;
    }

    private KeyValueList getQueryParametersWithObjectIdOnly(KeyValueList baseParams) {
        KeyValueList newParams = new KeyValueList();
        newParams.addAll(baseParams);
        newParams.add(new KeyValue("returnIdsOnly", "true"));
        return newParams;
    }

    public FeatureServiceQueryDataProvider setWhereClause(String whereClause) {
        if (whereClause == null || whereClause.isEmpty()) {
            whereClause = D_WHERE_CLAUSE;
        }
        this.whereClause = whereClause;
        return this;
    }

    public FeatureServiceQueryDataProvider setResultMaxSize(int resultMaxSize) {
        if (resultMaxSize <= 0 || resultMaxSize > 1000) {
            resultMaxSize = 1;
        }
        this.resultMaxSize = resultMaxSize;
        return this;
    }

    public FeatureServiceQueryDataProvider setSpatialRelationship(SpatialRelations spatialRelationship) {
        if (spatialRelationship == null) {
            spatialRelationship = D_SPAT_REL;
        }
        this.spatialRelationship = spatialRelationship;
        return this;
    }

    private boolean isJoinGeometryField() {
        boolean[] isReturnGeometry = new boolean[1];
        this.getFieldDefinitions().stream().forEach(fd -> {
            if (FieldType.Geometry.equals((Object)fd.getType())) {
                blArray[0] = true;
            }
        });
        return isReturnGeometry[0];
    }

    public FeatureServiceQueryDataProvider setBuffer_dist(double buffer_dist) {
        this.buffer_dist = buffer_dist < 0.0 ? 0.0 : buffer_dist;
        return this;
    }

    public FeatureServiceQueryDataProvider setBuffer_unit(SpatialUnits buffer_unit) {
        if (buffer_unit != null) {
            this.buffer_unit = buffer_unit;
        }
        return this;
    }

    public void shutdown() {
        this.dataSourceName = "";
        this.dataJoinFieldName = "";
        this.eventJoinFieldName = "";
        this.fields.clear();
        this.fieldDefs.clear();
        this.fieldDefsSelected.clear();
        this.fieldIndex.clear();
        this.arcGISServerConnectionManager.unregisterArcGISServerConnectionListener(this.arcGISServerConnectionName, (ArcGISServerConnectionStatusListener)this);
    }

    protected synchronized void getLayerInformation(boolean forceQuery) throws ValidationException, ConfigurationException {
        if (!forceQuery && this.layer != null) {
            return;
        }
        this.layer = this.arcGISServerConnection.getLayer(this.folder, this.dataSourceName, this.layerIdOrName, this.arcGISServerType);
        if (this.layer == null) {
            throw new ValidationException(LOGGER.translate("AGS_LAYER_DOESNT_EXIST", new Object[]{this.arcGISServerConnectionLabel, this.layerIdOrName, this.dataSourceName, this.folder}));
        }
        GeoEventDefinition ed = this.arcGISServerConnection.generateGeoEventDefinition(this.folder, this.dataSourceName, this.layer.getId(), this.outputGeoEventDefinitionName, this.arcGISServerType);
        int i = 0;
        for (FieldDefinition fd : ed.getFieldDefinitions()) {
            this.fieldIndex.put(fd.getName(), i++);
            this.fieldDefs.add(fd);
        }
        this.refreshSelected();
    }

    public synchronized void onArcGISServerConnectionStatusChange(String connectionName, ArcGISServerConnectionStatus newStatus) {
        if (connectionName.equals(this.arcGISServerConnectionName)) {
            boolean logErrorMessage = false;
            switch (newStatus) {
                case AVAILABLE: 
                case UPDATED: {
                    this.arcGISServerConnection = this.arcGISServerConnectionManager.getArcGISServerConnection(this.arcGISServerConnectionName);
                }
                case SYNC_SUCCESS: 
                case SYNC_ERROR: {
                    try {
                        this.getLayerInformation(true);
                    }
                    catch (ConfigurationException | ValidationException e) {
                        LOGGER.error(e.getMessage(), e);
                        logErrorMessage = true;
                        break;
                    }
                    if (this.arcGISServerConnection.isUseable(this.folder, this.dataSourceName, this.layerIdOrName, this.arcGISServerType)) break;
                    logErrorMessage = true;
                    break;
                }
                case DELETED: {
                    this.arcGISServerConnection = null;
                    logErrorMessage = true;
                }
            }
            if (logErrorMessage) {
                String layerDescForLog = "[" + this.arcGISServerConnectionLabel + "][" + this.folder + "][" + this.dataSourceName + "][" + this.layerIdOrName + "][" + this.arcGISServerType + "]";
                LOGGER.error("AGS_LAYER_UNAVAILABLE", new Object[]{this.arcGISServerConnectionLabel, layerDescForLog});
            }
        }
    }

    protected boolean isFolderExist() {
        if (this.folder.isEmpty()) {
            return true;
        }
        String[] stringArray = this.arcGISServerConnection.getFolders();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.equalsIgnoreCase(this.folder)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected boolean isServiceExist() {
        return this.arcGISServerConnection.hasService(this.folder, this.dataSourceName, this.arcGISServerType);
    }

    public List<FieldDefinition> getFieldDefinitions() {
        return this.fields.isEmpty() ? this.fieldDefs : this.fieldDefsSelected;
    }

    public String getFields() {
        StringBuffer sb = new StringBuffer();
        for (FieldDefinition attDef : this.getFieldDefinitions()) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(attDef.getName());
        }
        return sb.toString();
    }

    protected void refreshSelected() {
        this.fieldDefsSelected.clear();
        if (this.fieldDefs.size() > 0) {
            for (String field : this.fields) {
                int i = this.indexOf(field);
                if (i == -1) continue;
                this.fieldDefsSelected.add(this.fieldDefs.get(i));
            }
        }
    }

    protected int indexOf(String fieldName) {
        int i = 0;
        while (i < this.fieldDefs.size()) {
            if (this.fieldDefs.get(i).getName().equalsIgnoreCase(fieldName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void clearCache() {
        this.cache.clear();
    }

    public ArcGISServerType getArcGISServerType() {
        return this.arcGISServerType;
    }

    public void setArcGISServerType(ArcGISServerType serverType) {
        this.arcGISServerType = serverType;
    }

    public void setArcGISServerConnectionName(String name) {
        ArcGISServerConnection agsConnection;
        this.arcGISServerConnectionLabel = this.arcGISServerConnectionName = Validator.compactSpaces((String)name);
        if (this.arcGISServerConnectionManager != null && (agsConnection = this.arcGISServerConnectionManager.getArcGISServerConnection(name)) != null) {
            this.arcGISServerConnectionLabel = agsConnection.getLabel();
        }
    }

    public void setFolder(String folder) {
        this.folder = Validator.compactWhiteSpaces((String)folder);
        if (folder.equals("/") || "root".equals(folder.toLowerCase())) {
            this.folder = "";
        }
    }

    public void setDataSourceName(String dataSourceName) {
        this.shutdown();
        this.dataSourceName = Validator.compactSpaces((String)dataSourceName);
    }

    public void setLayer(String layerIdOrName) {
        this.layerIdOrName = Validator.compactSpaces((String)layerIdOrName);
    }

    public void setOutputGeoEventDefinitionName(String name) {
        this.outputGeoEventDefinitionName = Validator.compactSpaces((String)name, null);
    }

    public String getEventJoinFieldName() {
        return this.eventJoinFieldName;
    }

    public void setEventJoinFieldName(String eventJoinFieldName) {
        this.eventJoinFieldName = eventJoinFieldName;
    }

    public void setFields(String s) {
        this.fields.clear();
        String[] stringArray = Validator.compactSpaces((String)s).split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            if (!field.trim().isEmpty()) {
                this.fields.add(field.trim());
            }
            ++n2;
        }
        this.refreshSelected();
    }

    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public synchronized void setMaxCacheSize(int maxCacheSize) {
        if (maxCacheSize > 0 && this.maxCacheSize != maxCacheSize) {
            Map<Object, ExpirableData> oldCache = this.cache;
            this.cache = Collections.synchronizedMap(new LruLinkedHashMap(maxCacheSize));
            for (Map.Entry<Object, ExpirableData> entry : new ReverseIterator<Map.Entry<Object, ExpirableData>>(oldCache.entrySet())) {
                this.cache.put(entry.getKey(), entry.getValue());
            }
            oldCache.clear();
            oldCache = null;
            this.maxCacheSize = maxCacheSize;
        }
    }

    public int getExpiryTime() {
        return (int)this.expiryTime / 60000;
    }

    public synchronized void setExpiryTime(int minutes) {
        this.expiryTime = minutes > 0 ? minutes * 60000 : 0;
    }

    protected class ExpirableData {
        private Object[] data;
        private boolean expired;

        public ExpirableData(Object[] data) {
            this.expired = FeatureServiceQueryDataProvider.this.expiryTime != 0L;
            this.setData(data);
        }

        public boolean isDataExpired() {
            return this.expired;
        }

        public Object[] getData() {
            return this.data;
        }

        public void setData(Object[] data) {
            this.data = data;
            if (FeatureServiceQueryDataProvider.this.expiryTime > 0L) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ExpirableData.this.expired = false;
                            Thread.sleep(FeatureServiceQueryDataProvider.this.expiryTime);
                            ExpirableData.this.expired = true;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }).start();
            } else {
                this.expired = false;
            }
        }
    }

    private class LruLinkedHashMap<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = -8713217123249997885L;
        private final int maxSize;

        public LruLinkedHashMap(int maxSize) {
            super(maxSize, 1.0f, true);
            this.maxSize = maxSize;
        }

        @Override
        public V put(K key, V value) {
            if (super.containsKey(key)) {
                super.remove(key);
            }
            return super.put(key, value);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return super.size() > this.maxSize;
        }
    }

    private class ReverseIterator<T>
    implements Iterator<T>,
    Iterable<T> {
        private final List<T> list;
        private int position;

        public ReverseIterator(Collection<T> collection) {
            this.list = new ArrayList<T>(collection);
            this.position = this.list.size() - 1;
        }

        @Override
        public Iterator<T> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.position >= 0;
        }

        @Override
        public T next() {
            return this.list.get(this.position--);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

